/*-----------------------------------------------------------------------*
 * filename - crtlvcl.cpp
 *
 * function(s)
 *
 *   __CRTL_VCL_Init
 *   __CRTL_VCL_Exit
 *
 *
 *   Both functions are called from the startup code.  Init happens
 *   very early and Exit happens very late.
 *
 *-----------------------------------------------------------------------*/

/*
 *      C/C++ Run Time Library - Version 12.0
 *
 *      Copyright (c) 1997, 2005 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */

/* $Revision: 9.22 $        */

#include <windows.h>
#include <process.h>
#include <_defs.h>
#include "delphimm.h"

///////////////////////////////////////////////////////////////////////////

namespace System
{
    extern __declspec(package) HINSTANCE MainInstance;
    extern __declspec(package) bool      IsMultiThread;
    typedef void * (__fastcall * TSystemThreadFuncProc)(void *, void *);
    extern __declspec(package) TSystemThreadFuncProc SystemThreadFuncProc;
    typedef void (__fastcall * TSystemThreadEndProc)(int);
    extern __declspec(package) TSystemThreadEndProc SystemThreadEndProc;
};

///////////////////////////////////////////////////////////////////////////

extern "C"
{

///////////////////////////////////////////////////////////////////////////

void _RTLENTRY __CRTL_VCL_Sharemem (void);
extern unsigned char __isDLL;
extern unsigned char __isVCLPackage;

///////////////////////////////////////////////////////////////////////////
// Pascal Thread Functions                                               //
///////////////////////////////////////////////////////////////////////////

// Note: TThreadFunc and ThreadRec must match the same named definitions in
// the Pascal RTL's System.pas
typedef int (__fastcall * TThreadFunc) (void *);

#pragma option push -a8
struct ThreadRec
{
    ThreadRec(TThreadFunc f, void *p) :
        Func(f),
        Parameter(p),
        Ret(0)
    {
    }

    // These two members match those in Pascal's System.pas
    TThreadFunc Func;
    void *      Parameter;

    // Extra member (defined only in C++) used to hold the return value of the
    // thread function.
    int         Ret;
};
#pragma option pop

///////////////////////////////////////////////////////////////////////////

static void _USERENTRY AdoptionWrapper(void *param)
{
    ThreadRec *inner = reinterpret_cast<ThreadRec *>(param);

    if (inner)
    {
        // Run the specified function
        if (inner->Func)
            inner->Ret = inner->Func(inner->Parameter);
    }
}

///////////////////////////////////////////////////////////////////////////

static int __fastcall CppThreadWrapper(void *param)
{
    ThreadRec *inner = reinterpret_cast<ThreadRec *>(param);
    int ret = -1;

    if (inner)
    {
        _adopt_thread(AdoptionWrapper, inner, 1);
        ret = inner->Ret;
    }

    // Delete the inner ThreadRec
    delete inner;

    return ret;
}

///////////////////////////////////////////////////////////////////////////

static void * __fastcall CppThreadFuncProc(void *func, void *param)
{
    /*  CppThreadFuncProc is called from System.BeginThread in System.pas
        when System::SystemThreadFuncProc is pointed to it (which happens
        in __CRTL_VCL_Init).

        This function allocates and returns a ThreadRec that holds the
        function address and parameter that the user wants to execute in
        the new thread.  We need to have _adopt_thread called on the thread,
        so we wrap up two nested ThreadRec's the inner one with the user's
        data, and the outer one with our stub that adopts the thread.

        Although this routine is called for the threads created by TThread
        in VCL, the thread stub in TThread exits the thread early by calling
        EndThread().  So this routine is only useful for direct calls to
        System.BeginThread.  TThread instances will be cleaned up by the
        callout to CppThreadEndProc (see below).
    */

    ThreadRec *inner = NULL, *outer = NULL;

    try
    {
        // Outer is freed in Pascal (in System.ThreadWrapper() ) so we'll allocate
        // it such that CodeGuard won't complain about allocator/deallocator
        // mismatches.
        outer = static_cast<ThreadRec *>(System::GetMemory(sizeof(ThreadRec)));

        if (outer)
        {
            // Inner is freed by our C++ wrapper function so we'll use standard
            // C++
            inner = new ThreadRec(reinterpret_cast<TThreadFunc>(func), param);

            outer->Func = CppThreadWrapper;
            outer->Parameter = inner;
        }
    }
    catch(...)
    {
        delete inner;

        if (outer)
        {
            System::FreeMemory(outer);
            outer = NULL;
        }

    }

    return outer;
}

///////////////////////////////////////////////////////////////////////////

static void __fastcall CppThreadEndProc(int exit_code)
{
    /*  CppThreadEndProc is called from System.EndThread in System.pas
        when System::SystemThreadEndProc is pointed to it (which happens
        in __CRTL_VCL_Init).

        This function simply free's any thread local data that has been
        allocated during the life of the thread and then terminates the
        thread to the OS, setting the exit code.  Fortunately there is
        an RTL function that will do this for us.

        All TThread derived classes pass through here when they're finished
        running.
    */

    _endthreadex(exit_code);
}

///////////////////////////////////////////////////////////////////////////
// VCL Initializtion / Finalization Functions                            //
///////////////////////////////////////////////////////////////////////////

void _RTLENTRY __CRTL_VCL_Init (void)
{
    unsigned int hinst = _EDX;

    // We must set the VCL copy of hInstance (called MainInstance).
    // The startup code has placed this value into the EDX register for us.

    // Always set MainInstance in an EXE, and only set it in a DLL if it
    // hasn't been set.  Also, never set it in a PACKAGE.

    if (!__isVCLPackage)
        if ((!__isDLL) || (__isDLL && !System::MainInstance))
          System::MainInstance = (HINSTANCE) hinst;


    // We must tell the Pascal RTL to enforce multithread issues in its
    // memory allocation routines, since we are in the multi-threaded RTL
    // on the C/C++ side.

    System::IsMultiThread = true;


#if 0 // This needs to be done in the RTLDLL, not here!

    // We also tell the Pascal RTL to use our function to package up the
    // thread function and parameter to send off to its thread wrapper
    // function.

    System::SystemThreadFuncProc = CppThreadFuncProc;

    // We also tell the Pascal RTL to use our function to end any threads
    // that it started.

    System::SystemThreadEndProc = CppThreadEndProc;
#endif

    // Now initialize the Pascal RTL

    System::initialization();

#if defined(_BUILDRTLDLL)
    __CRTL_VCL_Sharemem();
#endif
}

///////////////////////////////////////////////////////////////////////////

void _RTLENTRY __CRTL_VCL_Exit (void)
{
// This cannot be performed now, since it prematurely unloads the memory
// manager DLL.  If the RTLDLL is being used, the RTL cannot free its memory
// without jumping into the non-existant memory manager DLL.  Therefore SYSTEM
// is initialized but never finalized.

//  #if defined(_BUILDRTLDLL)
//    System::Finalization();
//  #endif
}

//
// These functions start up and shut down VCL at the appropriate times.
//

void __stdcall __InitVCL(void);
void __stdcall __ExitVCL(void);

#pragma startup __InitVCL 28     // Initialization of early VCL routines.
                                 // Priority 28 is two eariler than what DCC32
                                 // uses for .PAS Units' Initialization
                                 // sections (which defaults to 30)

                                 // User's can now make a #29 priority startup
                                 // routine that will set IsLibrary = false
                                 // for statically linked DLLs that use VCL
                                 // Packages.

#pragma exit  __ExitVCL 31       // Finalization of VCL routines.
                                 // Priority 31 is one eariler than what DCC32
                                 // uses for .PAS Units' Finalization sections
                                 // (which defaults to 30)


///////////////////////////////////////////////////////////////////////////

} // extern "C"

///////////////////////////////////////////////////////////////////////////
